!function(){var e;e=function(){"use strict";suite("djblets/configForms/models/ListItem",()=>{window.describe("Default actions",()=>{window.describe("showRemove",()=>{window.it("true",()=>{var e=new Djblets.ConfigFormsListItem({showRemove:!0});window.expect(e.actions.length).toBe(1),window.expect(e.actions[0].id).toBe("delete")}),window.it("false",()=>{var e=new Djblets.ConfigFormsListItem({showRemove:!1});window.expect(e.actions.length).toBe(0)})})})}),window.suite("djblets/configForms/views/ListItemView",function(){window.describe("Rendering",function(){window.describe("General item display",function(){window.it("With editURL",function(){var e=new Djblets.ConfigFormsListItem({editURL:"http://example.com/",text:"Label"}),e=new Djblets.ConfigFormsListItemView({model:e});e.render(),window.expect(e.$el.html().trim()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n",'<a href="http://example.com/">Label</a>'].join(""))}),window.it("Without editURL",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=new Djblets.ConfigFormsListItemView({model:e});e.render(),window.expect(e.$el.html().trim()).toBe(['<span class="djblets-c-config-forms-list__item-actions">',"</span>\n","Label"].join(""))})}),window.describe("Item states",function(){const i=Djblets.ConfigFormsListItemView.extend({template:_.template(`<div><%- text %></div>
<div class="djblets-c-config-forms-list__item-state">
</div>`)});window.it("Initial render",function(){var e=new Djblets.ConfigFormsListItem({itemState:"enabled"}),e=new i({model:e}),e=(e.render(),window.expect(e.el).toHaveClass("-is-enabled"),e.$(".djblets-c-config-forms-list__item-state"));window.expect(e.text()).toBe("Enabled")}),window.it("When changed",function(){var e=new Djblets.ConfigFormsListItem({itemState:"enabled"}),t=new i({model:e}),e=(t.render(),e.set("itemState","disabled"),window.expect(t.el).toHaveClass("-is-disabled"),window.expect(t.el).not.toHaveClass("-is-enabled"),t.$(".djblets-c-config-forms-list__item-state"));window.expect(e.text()).toBe("Disabled")})}),window.describe("Actions",function(){window.it("Checkboxes",function(){var e=new Djblets.ConfigFormsListItem({checkboxAttr:!1,text:"Label"}),e=(e.setActions([{id:"mycheckbox",label:"Checkbox",propName:"checkboxAttr",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e}));e.render(),window.expect(e.$("input[type=checkbox]").length).toBe(1),window.expect(e.$("label").length).toBe(1)}),window.describe("Buttons",function(){window.it("Simple",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{id:"mybutton",label:"Button"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$("button.djblets-c-config-forms-list__item-action")),t=(window.expect(e.length).toBe(1),e[0]);window.expect(e.text()).toBe("Button"),window.expect(t).toHaveClass("config-forms-list-action-mybutton"),window.expect(t).not.toHaveClass("rb-icon"),window.expect(t).not.toHaveClass("-is-danger"),window.expect(t).not.toHaveClass("-is-primary")}),window.it("Danger",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{danger:!0,id:"mybutton",label:"Button"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$("button.djblets-c-config-forms-list__item-action")),t=(window.expect(e.length).toBe(1),e[0]);window.expect(e.text()).toBe("Button"),window.expect(t).toHaveClass("config-forms-list-action-mybutton"),window.expect(t).not.toHaveClass("rb-icon"),window.expect(t).not.toHaveClass("-is-primary"),window.expect(t).toHaveClass("-is-danger")}),window.it("Primary",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{id:"mybutton",label:"Button",primary:!0}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$("button.djblets-c-config-forms-list__item-action")),t=(window.expect(e.length).toBe(1),e[0]);window.expect(e.text()).toBe("Button"),window.expect(t).toHaveClass("config-forms-list-action-mybutton"),window.expect(t).not.toHaveClass("rb-icon"),window.expect(t).not.toHaveClass("-is-danger"),window.expect(t).toHaveClass("-is-primary")}),window.it("Icon names",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{danger:!1,iconName:"foo",id:"mybutton",label:"Button"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$("button.djblets-c-config-forms-list__item-action")),t=(window.expect(e.length).toBe(1),e[0]),t=(window.expect(e.text()).toBe("Button"),window.expect(t).toHaveClass("config-forms-list-action-mybutton"),window.expect(t).not.toHaveClass("-is-danger"),window.expect(t).not.toHaveClass("-is-primary"),e.find("span"));window.expect(t.length).toBe(1),window.expect(t.hasClass("djblets-icon")).toBe(!0),window.expect(t.hasClass("djblets-icon-foo")).toBe(!0)})}),window.describe("Menus",function(){let e,t;window.beforeEach(function(){(e=new Djblets.ConfigFormsListItem({text:"Label"})).setActions([{children:[{id:"mymenuitem",label:"My menu item"}],id:"mymenu",label:"Menu"}]),(t=new Djblets.ConfigFormsListItemView({model:e})).render()}),window.it("Initial display",function(){var e=t.$("button.djblets-c-config-forms-list__item-action");window.expect(e.length).toBe(1),window.expect(e.text()).toBe("Menu ▾")}),window.it("Opening",function(){window.spyOn(_,"defer").and.callFake(function(e){e()}),window.spyOn(t,"trigger");t.$(".config-forms-list-action-mymenu").click();var e=t.$(".djblets-c-config-forms-popup-menu");window.expect(e.length).toBe(1),window.expect(t.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopUp")}),window.it("Closing",function(){window.spyOn(_,"defer").and.callFake(e=>e());t.$(".config-forms-list-action-mymenu").click(),window.spyOn(t,"trigger"),$(document.body).click(),window.expect(t.trigger.calls.mostRecent().args[0]).toBe("actionMenuPopDown");var e=t.$(".action-menu");window.expect(e.length).toBe(0)})}),window.it("After render",()=>{var e=new Djblets.ConfigFormsListItem({text:"Label"}),t=new Djblets.ConfigFormsListItemView({model:e}),i=(t.render(),t.$("button.djblets-c-config-forms-list__item-action")),e=(window.expect(i.length).toBe(0),e.setActions([{id:"mybutton",label:"Button"}]),i=t.$("button.djblets-c-config-forms-list__item-action"),window.expect(i.length).toBe(1),i[0]);window.expect(i.text()).toBe("Button"),window.expect(e).toHaveClass("config-forms-list-action-mybutton"),window.expect(e).not.toHaveClass("rb-icon"),window.expect(e).not.toHaveClass("-is-danger"),window.expect(e).not.toHaveClass("-is-primary")})}),window.describe("Action properties",function(){window.describe("enabledPropName",function(){window.it("value == undefined",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{enabledPropName:"isEnabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!0)}),window.it("value == true",function(){var e=new Djblets.ConfigFormsListItem({isEnabled:!0,text:"Label"}),e=(e.setActions([{enabledPropName:"isEnabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!1)}),window.it("value == false",function(){var e=new Djblets.ConfigFormsListItem({isEnabled:!1,text:"Label"}),e=(e.setActions([{enabledPropName:"isEnabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!0)}),window.describe("with enabledPropInverse == true",function(){window.it("value == undefined",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{enabledPropInverse:!0,enabledPropName:"isDisabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!1)}),window.it("value == true",function(){var e=new Djblets.ConfigFormsListItem({isDisabled:!0,text:"Label"}),e=(e.setActions([{enabledPropInverse:!0,enabledPropName:"isDisabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!0)}),window.it("value == false",function(){var e=new Djblets.ConfigFormsListItem({isDisabled:!1,text:"Label"}),e=(e.setActions([{enabledPropInverse:!0,enabledPropName:"isDisabled",id:"mycheckbox",label:"Checkbox",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),e=(e.render(),e.$(".config-forms-list-action-mycheckbox"));window.expect(e.prop("disabled")).toBe(!1)})})})})}),window.describe("Action handlers",function(){window.it("Buttons",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{id:"mybutton",label:"Button"}]),new Djblets.ConfigFormsListItemView({model:e})),t=(e.actionHandlers={mybutton:"_onMyButtonClick"},e._onMyButtonClick=jasmine.createSpy("_onMyButtonClick"),e.render(),e.$("button.djblets-c-config-forms-list__item-action"));window.expect(t.length).toBe(1),t.click(),window.expect(e._onMyButtonClick).toHaveBeenCalled()}),window.it("Checkboxes",function(){var e=new Djblets.ConfigFormsListItem({checkboxAttr:!1,text:"Label"}),t=(e.setActions([{id:"mycheckbox",label:"Checkbox",propName:"checkboxAttr",type:"checkbox"}]),new Djblets.ConfigFormsListItemView({model:e})),t=(t.actionHandlers={mybutton:"_onMyButtonClick"},t._onMyButtonClick=jasmine.createSpy("_onMyButtonClick"),t.render(),t.$("input[type=checkbox]"));window.expect(t.length).toBe(1),window.expect(t.prop("checked")).toBe(!1),t.prop("checked",!0).triggerHandler("change"),window.expect(e.get("checkboxAttr")).toBe(!0)})})}),window.suite("djblets/configForms/views/ListView",()=>{let t,e,i;window.beforeEach(()=>{t=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.ConfigFormsListItem}),e=new Djblets.ConfigFormsList({},{collection:t}),i=new Djblets.ConfigFormsListView({model:e})}),window.describe("Methods",()=>{window.describe("render",()=>{window.it("On first render",()=>{window.expect(i.$listBody).toBeNull(),window.expect(i.$("li").length).toBe(0),i.render(),window.expect(i.$listBody).toBe(i.$el),window.expect(i.$("li").length).toBe(3)}),window.it("On subsequent render",()=>{window.expect(i.$listBody).toBeNull(),window.expect(i.$("li").length).toBe(0),i.render(),window.expect(i.$listBody).toBe(i.$el),window.expect(i.$("li").length).toBe(3),i.$el.append("<button>"),i.$listBody=$("<input>"),i.render(),window.expect(i.$listBody).toBe(i.$el),window.expect(i.$("li").length).toBe(3),window.expect(i.$("button").length).toBe(0),window.expect(i.$("input").length).toBe(0)})})}),window.describe("Manages items",()=>{window.beforeEach(()=>{i.render()}),window.it("On render",()=>{var e=i.$("li");window.expect(e.length).toBe(3),window.expect(e.eq(0).text().trim()).toBe("Item 1"),window.expect(e.eq(1).text().trim()).toBe("Item 2"),window.expect(e.eq(2).text().trim()).toBe("Item 3")}),window.it("On add",()=>{t.add({text:"Item 4"});var e=i.$("li");window.expect(e.length).toBe(4),window.expect(e.eq(3).text().trim()).toBe("Item 4")}),window.it("On remove",()=>{t.remove(t.at(0));var e=i.$("li");window.expect(e.length).toBe(2),window.expect(e.eq(0).text().trim()).toBe("Item 2")}),window.it("On reset",()=>{t.reset([{text:"Foo"},{text:"Bar"}]);var e=i.$("li");window.expect(e.length).toBe(2),window.expect(e.eq(0).text().trim()).toBe("Foo"),window.expect(e.eq(1).text().trim()).toBe("Bar")})})}),window.suite("djblets/configForms/views/TableItemView",function(){window.describe("Rendering",function(){window.describe("Item display",function(){window.it("With editURL",function(){var e=new Djblets.ConfigFormsListItem({editURL:"http://example.com/",text:"Label"}),e=new Djblets.ConfigFormsTableItemView({model:e});e.render(),window.expect(e.$el.html().trim()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n",'<a href="http://example.com/">Label</a>\n\n',"</td>"].join(""))}),window.it("Without editURL",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=new Djblets.ConfigFormsTableItemView({model:e});e.render(),window.expect(e.$el.html().trim()).toBe(["<td>",'<span class="djblets-c-config-forms-list__item-actions">',"</span>\n\n","Label\n\n","</td>"].join(""))})}),window.describe("Action placement",function(){window.it("Default template",function(){var e=new Djblets.ConfigFormsListItem({text:"Label"}),e=(e.setActions([{id:"mybutton",label:"Button"}]),new Djblets.ConfigFormsTableItemView({model:e})),e=(e.render(),e.$("td:last button.djblets-c-config-forms-list__item-action"));window.expect(e.length).toBe(1),window.expect(e.text()).toBe("Button")}),window.it("Custom template",function(){var e;let t=Spina.spina({prototypeAttrs:["template"]})((n=class extends Djblets.ConfigFormsTableItemView{},e=n,i="template",o=_.template(`<td></td>
<td></td>`),i in e?Object.defineProperty(e,i,{value:o,enumerable:!0,configurable:!0,writable:!0}):e[i]=o,e=n))||e;var i=new Djblets.ConfigFormsListItem({text:"Label"}),o=(i.setActions([{id:"mybutton",label:"Button"}]),new t({model:i})),n=(o.render(),o.$("td:last button.djblets-c-config-forms-list__item-action"));window.expect(n.length).toBe(1),window.expect(n.text()).toBe("Button")})})})}),window.suite("djblets/configForms/views/TableView",()=>{window.describe("Manages rows",()=>{let t,e,i;window.beforeEach(()=>{t=new Backbone.Collection([{text:"Item 1"},{text:"Item 2"},{text:"Item 3"}],{model:Djblets.ConfigFormsListItem}),e=new Djblets.ConfigFormsList({},{collection:t}),(i=new Djblets.ConfigFormsTableView({model:e})).render()}),window.it("On render",()=>{var e=i.$("tr");window.expect(e.length).toBe(3),window.expect(e.eq(0).text().trim()).toBe("Item 1"),window.expect(e.eq(1).text().trim()).toBe("Item 2"),window.expect(e.eq(2).text().trim()).toBe("Item 3")}),window.it("On add",()=>{t.add({text:"Item 4"});var e=i.$("tr");window.expect(e.length).toBe(4),window.expect(e.eq(3).text().trim()).toBe("Item 4")}),window.it("On remove",()=>{t.remove(t.at(0));var e=i.$("tr");window.expect(e.length).toBe(2),window.expect(e.eq(0).text().trim()).toBe("Item 2")}),window.it("On reset",()=>{t.reset([{text:"Foo"},{text:"Bar"}]);var e=i.$("tr");window.expect(e.length).toBe(2),window.expect(e.eq(0).text().trim()).toBe("Foo"),window.expect(e.eq(1).text().trim()).toBe("Bar")})})})},"function"==typeof define&&define.amd?define(e):e(),suite("djblets/gravy/backboneUtils",function(){var o;beforeEach(function(){o=new Backbone.Model}),describe("$.fn.bindClass",function(){var e;beforeEach(function(){e=$("<div>").appendTo(document.body)}),describe("Initial class value",function(){it("Adds class when true",function(){o.set("mybool",!0),e.bindClass(o,"mybool","myclass"),expect(e.hasClass("myclass")).toBe(!0)}),it("No class when false",function(){o.set("mybool",!1),e.bindClass(o,"mybool","myclass"),expect(e.hasClass("myclass")).toBe(!1)}),describe("With inverse",function(){it("No class when true",function(){o.set("mybool",!0),e.bindClass(o,"mybool","myclass",{inverse:!0}),expect(e.hasClass("myclass")).toBe(!1)}),it("Adds class when false",function(){o.set("mybool",!1),e.bindClass(o,"mybool","myclass",{inverse:!0}),expect(e.hasClass("myclass")).toBe(!0)})})}),describe("Model property changes",function(){it("Removes class when true -> false",function(){o.set("mybool",!0),e.bindClass(o,"mybool","myclass"),o.set("mybool",!1),expect(e.hasClass("myclass")).toBe(!1)}),it("Adds class when false -> true",function(){o.set("mybool",!1),e.bindClass(o,"mybool","myclass"),o.set("mybool",!0),expect(e.hasClass("myclass")).toBe(!0)}),describe("With inverse",function(){it("Adds class when true -> false",function(){o.set("mybool",!0),e.bindClass(o,"mybool","myclass",{inverse:!0}),o.set("mybool",!1),expect(e.hasClass("myclass")).toBe(!0)}),it("Removes class when false -> true",function(){o.set("mybool",!1),e.bindClass(o,"mybool","myclass",{inverse:!0}),o.set("mybool",!0),expect(e.hasClass("myclass")).toBe(!1)})})})}),describe("$.fn.bindProperty",function(){var e,t,i;beforeEach(function(){e=$("<input type='checkbox'>").appendTo(document.body),t=$('<input type="radio" name="my-radio" value="one">').appendTo(document.body),i=$('<input type="radio" name="my-radio" value="two">').appendTo(document.body)}),afterEach(function(){e.remove(),t.remove(),i.remove()}),describe("Initial property values",function(){it("Setting element's property from model property's",function(){o.set("mybool",!0),e.bindProperty("checked",o,"mybool"),expect(e.prop("checked")).toBe(!0)}),it("Setting element's property from model property's with inverse=true",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool",{inverse:!0}),expect(e.prop("checked")).toBe(!0),expect(o.get("mybool")).toBe(!1)}),it("Setting element's property from model property with radioValue",function(){o.set("myvalue","one"),t.bindProperty("checked",o,"myvalue",{radioValue:"one"}),i.bindProperty("checked",o,"myvalue",{radioValue:"two"}),expect(t.prop("checked")).toBe(!0),expect(i.prop("checked")).toBe(!1),expect(o.get("myvalue")).toBe("one")}),it("No element changes with modelToElement=false",function(){o.set("mybool",!0),e.bindProperty("checked",o,"mybool",{modelToElement:!1}),expect(e.prop("checked")).toBe(!1)})}),describe("Model property changes",function(){it("Setting element's property",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool"),expect(e.prop("checked")).toBe(!1),o.set("mybool",!0),expect(e.prop("checked")).toBe(!0)}),it("Setting element's property with inverse=true",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool",{inverse:!0}),expect(e.prop("checked")).toBe(!0),o.set("mybool",!0),expect(e.prop("checked")).toBe(!1),expect(o.get("mybool")).toBe(!0)}),it("Setting element's property with radioValue",function(){o.set("myvalue","one"),t.bindProperty("checked",o,"myvalue",{radioValue:"one"}),i.bindProperty("checked",o,"myvalue",{radioValue:"two"}),expect(t.prop("checked")).toBe(!0),expect(i.prop("checked")).toBe(!1),o.set("myvalue","two"),expect(t.prop("checked")).toBe(!1),expect(i.prop("checked")).toBe(!0),expect(o.get("myvalue")).toBe("two")}),it("No element changes with modelToElement=false",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool",{modelToElement:!1}),o.set("mybool",!0),expect(e.prop("checked")).toBe(!1)})}),describe("Element property changes",function(){it("Setting model's property",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool"),e.click(),expect(e.prop("checked")).toBe(!0),expect(o.get("mybool")).toBe(!0)}),it("Setting model's property with inverse=true",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool",{inverse:!0}),e.prop("checked",!1),e.click(),expect(e.prop("checked")).toBe(!0),expect(o.get("mybool")).toBe(!1)}),it("Setting model's property with radioValue",function(){o.set("myvalue","one"),t.bindProperty("checked",o,"myvalue",{radioValue:"one"}),i.bindProperty("checked",o,"myvalue",{radioValue:"two"}),i.click(),expect(t.prop("checked")).toBe(!1),expect(i.prop("checked")).toBe(!0),expect(o.get("myvalue")).toBe("two")}),it("No model changes with elementToModel=false",function(){o.set("mybool",!1),e.bindProperty("checked",o,"mybool",{elementToModel:!1}),e.click(),expect(e.prop("checked")).toBe(!0),expect(o.get("mybool")).toBe(!1)})}),describe("Special properties",function(){it("text",function(){var e=$("<p>");e.bindProperty("text",o,"text",{elementToModel:!1}),o.set("text","hello world!"),expect(e.text()).toBe("hello world!")}),it("html",function(){var e=$("<p>");e.bindProperty("html",o,"html",{elementToModel:!1}),o.set("html","<b>hello world!</b>"),expect(e.html()).toBe("<b>hello world!</b>")})})}),describe("$.fn.bindVisibility",function(){var e;beforeEach(function(){e=$("<div>").appendTo(document.body)}),afterEach(function(){e.remove()}),describe("Showing elements",function(){it("When property is initially true",function(){e.hide(),o.set("mybool",!0),e.bindVisibility(o,"mybool"),expect(e.is(":visible")).toBe(!0)}),it("When property is initially false with inverse=true",function(){e.hide(),o.set("mybool",!1),e.bindVisibility(o,"mybool",{inverse:!0}),expect(e.is(":visible")).toBe(!0)}),it("When property is changed to true",function(){expect(e.is(":visible")).toBe(!0),o.set("mybool",!1),e.bindVisibility(o,"mybool"),o.set("mybool",!0),expect(e.is(":visible")).toBe(!0)}),it("When property is changed to false with inverse=true",function(){e.hide(),o.set("mybool",!0),e.bindVisibility(o,"mybool",{inverse:!0}),o.set("mybool",!1),expect(e.is(":visible")).toBe(!0)})}),describe("Hiding elements",function(){it("When property is initially false",function(){expect(e.is(":visible")).toBe(!0),o.set("mybool",!1),e.bindVisibility(o,"mybool"),expect(e.is(":visible")).toBe(!1)}),it("When property is initially true with inverse=true",function(){expect(e.is(":visible")).toBe(!0),o.set("mybool",!0),e.bindVisibility(o,"mybool",{inverse:!0}),expect(e.is(":visible")).toBe(!1)}),it("When property is changed to false",function(){e.hide(),o.set("mybool",!0),e.bindVisibility(o,"mybool"),o.set("mybool",!1),expect(e.is(":visible")).toBe(!1)}),it("When property is changed to true with inverse=true",function(){expect(e.is(":visible")).toBe(!0),o.set("mybool",!1),e.bindVisibility(o,"mybool",{inverse:!0}),o.set("mybool",!0),expect(e.is(":visible")).toBe(!1)})})})}),suite("djblets/forms/models/ConditionChoice",function(){describe("Initialization",function(){it("With parse and data",function(){var e=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op",useValue:!1}],valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}}},{parse:!0}),e=(expect(e.id).toBe("my-choice"),expect(e.get("name")).toBe("My Choice"),expect(e.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}),expect(e.operators.length).toBe(1),e.operators.at(0));expect(e.id).toBe("my-op"),expect(e.get("name")).toBe("My Op"),expect(e.get("useValue")).toBe(!1)})}),describe("Methods",function(){it("createValueField",function(){var e=new Djblets.Forms.ConditionChoice({id:"my-choice",name:"My Choice",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}}).createValueField("my-field");expect(e.model.get("fieldName")).toBe("my-field")})})}),suite("djblets/forms/models/Condition",function(){describe("Events",function(){describe("choice changes",function(){let e,t,i;beforeEach(function(){(e=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"})).operators.add({id:"my-op-1",name:"My Op 1"}),(t=new Djblets.Forms.ConditionChoice({id:"my-choice-1",name:"My Choice 1"})).operators.add([{id:"my-op-2",name:"My Op 2"},{id:"my-op-3",name:"My Op 3"}]),(i=new Djblets.Forms.Condition({choice:e,operator:e.operators.first(),value:"abc123"})).set("choice",t)}),it("Operator resets to first",function(){expect(i.get("operator")).toBe(t.operators.first())}),it("Value resets",function(){expect(i.get("value")).toBe(void 0)})})})}),suite("djblets/forms/models/ConditionOperator",function(){describe("Initialization",function(){it("With parse and data",function(){var e=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:!0,valueField:{model:{className:"Djblets.Forms.ConditionValueField",data:{myModelKey:"my-value"}},view:{className:"Djblets.Forms.ConditionValueFormFieldView",data:{myViewKey:"my-value"}}}},{parse:!0});expect(e.id).toBe("my-op"),expect(e.get("name")).toBe("My Operator"),expect(e.get("useValue")).toBe(!0),expect(e.get("valueField")).toEqual({modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}})}),it("With parse and data, but no valueField",function(){var e=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",useValue:!0},{parse:!0});expect(e.id).toBe("my-op"),expect(e.get("name")).toBe("My Operator"),expect(e.get("valueField")).toBe(null),expect(e.get("useValue")).toBe(!0)})}),describe("createValueField",function(){it("With custom valueField",function(){var e=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator",valueField:{modelClass:Djblets.Forms.ConditionValueField,modelData:{myModelKey:"my-value"},viewClass:Djblets.Forms.ConditionValueFormFieldView,viewData:{myViewKey:"my-value"}}}).createValueField("my-field");expect(e.model.get("fieldName")).toBe("my-field")}),it("Without custom valueField",function(){const e=new Djblets.Forms.ConditionOperator({id:"my-op",name:"My Operator"});expect(()=>e.createValueField("my-field")).toThrowError("This operator does not have a custom valueField.")})})}),suite("djblets/forms/models/ConditionSet",function(){describe("Initialization",function(){it("choicesData parsed",function(){var e=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice"}],fieldName:"my-conditions"});expect(e.choices.length).toBe(1),expect(e.choices.at(0).id).toBe("my-choice"),expect(e.get("lastID")).toBe(null)}),it("conditionsData parsed",function(){var e=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"my-choice",error:"My error",operatorID:"my-op-1",valid:!1,value:"abc123"},{choiceID:"my-choice",operatorID:"my-op-2",valid:!0,value:42}]}),t=e.conditions;expect(t.length).toBe(2);let i=t.at(0);expect(i.id).toBe(0),expect(i.get("choice").id).toBe("my-choice"),expect(i.get("operator").id).toBe("my-op-1"),expect(i.get("value")).toBe("abc123"),expect(i.get("valid")).toBe(!1),expect(i.get("error")).toBe("My error"),i=t.at(1),expect(i.id).toBe(1),expect(i.get("choice").id).toBe("my-choice"),expect(i.get("operator").id).toBe("my-op-2"),expect(i.get("value")).toBe(42),expect(i.get("valid")).toBe(!0),expect(i.get("error")).toBe(null),expect(e.get("lastID")).toBe(1)}),it("conditionsData parsed with bad choiceID",function(){var e=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op-1",name:"My Op 1"},{id:"my-op-2",name:"My Op 2"}]}],conditionsData:[{choiceID:"invalid-choice",error:"My error",operatorID:"my-op-1",valid:!1,value:"abc123"}]}),t=e.conditions,t=(expect(t.length).toBe(1),t.at(0));expect(t.id).toBe(0),expect(t.get("choice")).toBe(null),expect(t.get("operator")).toBe(null),expect(t.get("value")).toBe("abc123"),expect(t.get("valid")).toBe(!1),expect(t.get("error")).toBe("My error"),expect(e.get("lastID")).toBe(0)})}),describe("Adding to conditions collection",function(){let t;beforeEach(function(){t=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}]}),expect(t.get("lastID")).toBe(null)}),it("Using choice and operator IDs",function(){t.conditions.add({choiceID:"my-choice",error:"My error",operatorID:"my-op",valid:!1,value:"abc123"});var e=t.conditions,e=(expect(e.length).toBe(1),e.at(0));expect(e.id).toBe(0),expect(e.get("choice").id).toBe("my-choice"),expect(e.get("operator").id).toBe("my-op"),expect(e.get("value")).toBe("abc123"),expect(e.get("valid")).toBe(!1),expect(e.get("error")).toBe("My error"),expect(t.get("lastID")).toBe(0)}),it("Using choice instance",function(){t.conditions.add({choiceID:t.choices.at(0),error:"My error",operatorID:"my-op",valid:!1,value:"abc123"});var e=t.conditions,e=(expect(e.length).toBe(1),e.at(0));expect(e.id).toBe(0),expect(e.get("choice").id).toBe("my-choice"),expect(e.get("operator").id).toBe("my-op"),expect(e.get("value")).toBe("abc123"),expect(e.get("valid")).toBe(!1),expect(e.get("error")).toBe("My error"),expect(t.get("lastID")).toBe(0)}),it("Using operator instance",function(){t.conditions.add({choiceID:"my-choice",error:"My error",operatorID:t.choices.at(0).operators.at(0),valid:!1,value:"abc123"});var e=t.conditions,e=(expect(e.length).toBe(1),e.at(0));expect(e.id).toBe(0),expect(e.get("choice").id).toBe("my-choice"),expect(e.get("operator").id).toBe("my-op"),expect(e.get("value")).toBe("abc123"),expect(e.get("valid")).toBe(!1),expect(e.get("error")).toBe("My error"),expect(t.get("lastID")).toBe(0)})}),describe("Methods",function(){it("addNewCondition",function(){var e=new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice",name:"My Choice",operators:[{id:"my-op",name:"My Op"}]}],fieldName:"my-conditions"}),t=e.conditions,e=(expect(t.length).toBe(0),expect(e.get("lastID")).toBe(null),e.addNewCondition(),expect(t.length).toBe(1),expect(e.get("lastID")).toBe(0),t.at(0));expect(e.id).toBe(0),expect(e.get("choice").id).toBe("my-choice"),expect(e.get("operator").id).toBe("my-op")})})}),suite("djblets/forms/views/ConditionValueFormFieldView",function(){function t(e){return{model:{className:"Djblets.Forms.ConditionValueField",data:{fieldHTML:e}},view:{className:"Djblets.Forms.ConditionValueFormFieldView"}}}function s(e){e=new Djblets.Forms.ConditionSetView({el:$(` <div class="conditions-field">
  <input type="hidden" name="my_conditions_last_id">
  <div class="conditions-field-mode"></div>
  <div class="conditions-field-rows-container">
   <ul class="conditions-field-rows"></ul>
   <div class="conditions-field-add-condition">
    <a href="#" class="conditions-field-action"></a>
   </div>
 </div>
</div>`),model:new Djblets.Forms.ConditionSet({choicesData:[{id:"my-choice-1",name:"My Choice 1",operators:[{id:"my-op-1",name:"My Op 1",useValue:!0},{id:"my-op-2",name:"My Op 2",useValue:!0,valueField:t('<input type="number">')}],valueField:t('<input type="text">')},{id:"my-choice-2",name:"My Choice 2",operators:[{id:"my-op-3",name:"My Op 3",useValue:!0},{id:"my-op-4",name:"My Op 4",useValue:!0}],valueField:t('<input type="email">')}],conditionsData:e,fieldName:"my_conditions"},{parse:!0})});return e.render(),e}describe("Rendering",function(){it("Loaded rows",function(){var e=s([{choiceID:"my-choice-1",operatorID:"my-op-1",valid:!0,value:"<test>"},{choiceID:"my-choice-2",operatorID:"my-op-4",valid:!0,value:42}]),t=e.$(".conditions-field-row"),e=(expect(t.length).toBe(2),e.$("input[name=my_conditions_last_id]"));expect(e.val()).toBe("1");let i=t.eq(0),o=i.find(".conditions-field-choice"),n=(expect(o.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join("")),expect(o.children("select").val()).toBe("my-choice-1"),i.find(".conditions-field-operator")),c=(expect(n.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join("")),expect(n.children("select").val()).toBe("my-op-1"),i.find(".conditions-field-value")),a=c.find("input");expect(a.parent().prop("tagName")).toBe("SPAN"),expect(a.attr("type")).toBe("text"),expect(a.attr("name")).toBe("my_conditions_value[0]"),expect(a.val()).toBe("<test>"),i=t.eq(1),o=i.find(".conditions-field-choice"),expect(o.html()).toBe(['<select name="my_conditions_choice[1]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join("")),expect(o.children("select").val()).toBe("my-choice-2"),n=i.find(".conditions-field-operator"),expect(n.html()).toBe(['<select name="my_conditions_operator[1]">','<option value="my-op-3">My Op 3</option>','<option value="my-op-4">My Op 4</option>',"</select>"].join("")),expect(n.children("select").val()).toBe("my-op-4"),c=i.find(".conditions-field-value"),a=c.find("input"),expect(a.parent().prop("tagName")).toBe("SPAN"),expect(a.attr("type")).toBe("email"),expect(a.attr("name")).toBe("my_conditions_value[1]"),expect(a.val()).toBe("42")}),it("Loaded rows with errors",function(){var e=s([{choiceID:"my-choice-1",error:"This is an <error>.",operatorID:"my-op-1",valid:!0,value:"<test>"}]),t=e.$(".conditions-field-row"),e=(expect(t.length).toBe(1),e.$("input[name=my_conditions_last_id]"));expect(e.val()).toBe("0");e=t.eq(0).find(".conditions-field-error");expect(e.length).toBe(1),expect(e.html()).toBe("This is an &lt;error&gt;.")})}),describe("Actions",function(){it("Add a new condition",function(){var e=s(),t=e.$(".conditions-field-row"),i=(expect(t.length).toBe(0),e.$("input[name=my_conditions_last_id]")),e=(expect(i.val()).toBe(""),spyOn(e.model,"addNewCondition").and.callThrough(),e.$(".conditions-field-add-condition a").click(),expect(e.model.addNewCondition).toHaveBeenCalled(),t=e.$(".conditions-field-row"),expect(t.length).toBe(1),expect(i.val()).toBe("0"),t.eq(0)),i=e.find(".conditions-field-choice"),t=(expect(i.html()).toBe(['<select name="my_conditions_choice[0]">','<option value="my-choice-1">My Choice 1</option>','<option value="my-choice-2">My Choice 2</option>',"</select>"].join("")),expect(i.children("select").val()).toBe("my-choice-1"),e.find(".conditions-field-operator"));expect(t.html()).toBe(['<select name="my_conditions_operator[0]">','<option value="my-op-1">My Op 1</option>','<option value="my-op-2">My Op 2</option>',"</select>"].join("")),expect(t.children("select").val()).toBe("my-op-1");i=e.find(".conditions-field-value").find("input");expect(i.parent().prop("tagName")).toBe("SPAN"),expect(i.attr("type")).toBe("text"),expect(i.attr("name")).toBe("my_conditions_value[0]"),expect(i.val()).toBe("")}),it("Delete a condition",function(){var e=s([{choiceID:"my-choice-1",operatorID:"my-op-1",valid:!0,value:"<test>"}]);let t=e.$(".conditions-field-row");expect(e.model.conditions.length).toBe(1),expect(t.length).toBe(1);var i=e.$("input[name=my_conditions_last_id]"),o=(expect(i.val()).toBe("0"),e.model.conditions.at(0));spyOn(o,"destroy").and.callThrough(),t.eq(0).find(".conditions-field-row-delete").click(),expect(o.destroy).toHaveBeenCalled(),t=e.$(".conditions-field-row"),expect(e.model.conditions.length).toBe(0),expect(t.length).toBe(0),expect(i.val()).toBe("0")}),it("Changing a choice updates model",function(){var e=s([{choiceID:"my-choice-1",operatorID:"my-op-1",valid:!0,value:"<test>"}]),t=e.$(".conditions-field-row"),e=e.model.conditions.at(0);t.eq(0).find(".conditions-field-choice select").val("my-choice-2").trigger("change"),expect(e.get("choice").id).toBe("my-choice-2")}),it("Changing an operator updates model",function(){var e=s([{choiceID:"my-choice-1",operatorID:"my-op-1",valid:!0,value:"<test>"}]),t=e.$(".conditions-field-row"),e=e.model.conditions.at(0);t.eq(0).find(".conditions-field-operator select").val("my-op-2").trigger("change"),expect(e.get("operator").id).toBe("my-op-2")})}),describe("Model events",function(){let t,i,o,n,c,a,l;beforeEach(function(){t=s([{choiceID:"my-choice-1",operatorID:"my-op-1",valid:!0,value:"<test>"}]),i=t.model,o=i.conditions.at(0),n=t.$(".conditions-field-row").eq(0),c=n.find(".conditions-field-choice select"),a=n.find(".conditions-field-operator select");var e=(l=n.find(".conditions-field-value")).find("input");expect(e.attr("type")).toBe("text"),expect(e.val()).toBe("<test>")}),describe("Choice changed",function(){it("Updates UI state",function(){o.set("choice",i.choices.get("my-choice-2")),expect(c.val()).toBe("my-choice-2"),expect(a.val()).toBe("my-op-3");var e=l.find("input");expect(e.attr("type")).toBe("email"),expect(e.val()).toBe("")})}),describe("Operator changed",function(){it("Updates UI state",function(){var e=i.choices.get("my-choice-1"),e=(o.set("operator",e.operators.get("my-op-2")),expect(c.val()).toBe("my-choice-1"),expect(a.val()).toBe("my-op-2"),l.find("input"));expect(e.attr("type")).toBe("number"),expect(e.val()).toBe("")}),it("Retains value if valueField remains",function(){var e=i.choices.get("my-choice-2");o.set("choice",e),l.find("input").val("42"),expect(a.val()).toBe("my-op-3"),o.set("operator",e.operators.get("my-op-4")),expect(l.find("input").val()).toBe("42")})}),describe("Value changed",function(){it("Updated UI state",function(){o.set("value","new-value"),expect(l.find("input").val()).toBe("new-value")})})})}),suite("djblets/forms/views/ConditionValueFormFieldView",function(){function t(e){e=new Djblets.Forms.ConditionValueFormFieldView({model:new Djblets.Forms.ConditionValueField({fieldHTML:e,fieldName:"my-field"})});return e.render(),e}it("Rendering",function(){var e=t('<input type="text">');expect(e.$input[0].tagName).toBe("INPUT"),expect(e.$input.attr("type")).toBe("text"),expect(e.$input.attr("name")).toBe("my-field")}),describe("Methods",function(){describe("getValue",function(){it("<input>",function(){var e=t('<input type="text" value="abc123">');expect(e.getValue()).toBe("abc123")}),it("<select>",function(){var e=t(["<select>",'<option value="1">One</option>','<option value="2" selected="selected">Two</option>',"</select>"].join(""));expect(e.getValue()).toBe("2")}),it("<textarea>",function(){var e=t("<textarea></textarea>");e.setValue("abc123"),expect(e.$input.val()).toBe("abc123")})}),describe("setValue",function(){it("<input>",function(){var e=t('<input type="text">');e.setValue("abc123"),expect(e.$input.val()).toBe("abc123")}),it("<select>",function(){var e=t(["<select>",'<option value="1">One</option>','<option value="2">Two</option>',"</select>"].join(""));e.setValue("2"),expect(e.$input.val()).toBe("2")}),it("<textarea>",function(){var e=t("<textarea></textarea>");e.setValue("abc123"),expect(e.$input.val()).toBe("abc123")})})})}),suite("djblets/forms/views/ListEditView",function(){function c(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[],t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:`<input type="text"
    class="djblets-c-list-edit-widget__input"
    id="_value___EDIT_LIST_ROW_ID__"
    name="_value[__EDIT_LIST_ROW_INDEX__]">`,e=$(i({renderedDefaultRow:t.replaceAll("__EDIT_LIST_ROW_ID__","0").replaceAll("__EDIT_LIST_ROW_INDEX__","0"),renderedRows:e})).appendTo($testsScratch);return(e=new Djblets.Forms.ListEditView({el:e,fieldName:"",removeText:"Remove this item.",renderedDefaultRow:t})).render(),[e,e.$('input[name="_num_rows"]')]}const i=_.template(`<div class="djblets-c-list-edit-widget list-edit-widget">
<input type="hidden" name="_num_rows" value="<%- renderedRows.length %>">
  <ul class="djblets-c-list-edit-widget__entries">
  <% if (renderedRows.length > 0) { %>
    <% renderedRows.forEach(function(row, i) { %>
    <li class="djblets-c-list-edit-widget__entry"
        data-list-index="<%- i %>">
    <%= row %>
    <a href="#" class="djblets-c-list-edit-widget__remove-item"
        role="button">
    <span class="fa fa-times"></span>
    </a>
    </li>
  <% }); %>
  <% } else { %>
    <li class="djblets-c-list-edit-widget__entry" data-list-index="0">
    <%= renderedDefaultRow %>
    <a href="#" class="djblets-c-list-edit-widget__remove-item"></a>
    </li>
  <% } %>
  </ul>
 <button class="djblets-c-list-edit-widget__add-item btn" role="button">
 <span class="fa fa-plus"></span>
 </button>
</div>`);describe("Removal",function(){it("With no values",function(){var[e,t]=c([]);expect(t.val()).toEqual("1"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);let i=e.$(".djblets-c-list-edit-widget__input");expect(i.val()).toEqual(""),expect(i.attr("id")).toEqual("_value_0"),expect(i.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__remove-item").click(),expect(t.val()).toEqual("1"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(1),i=e.$(".djblets-c-list-edit-widget__input"),expect(i.val()).toEqual(""),expect(i.attr("id")).toMatch(/^_value_djblets-list-edit-row\d+/),expect(i.attr("name")).toEqual("_value[0]")}),it("With one value",function(){var[e,t]=c([`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID"
       name="_value[0]"
       value="One">`]);expect(t.val()).toEqual("1"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(1);let i=e.$(".djblets-c-list-edit-widget__input");expect(i.val()).toEqual("One"),expect(i.attr("id")).toEqual("_value_UUID"),expect(i.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__remove-item").click(),expect(t.val()).toEqual("1"),i=e.$(".djblets-c-list-edit-widget__input"),expect(i.val()).toEqual(""),expect(i.attr("id")).toMatch(/^_value_djblets-list-edit-row\d+/),expect(i.attr("name")).toEqual("_value[0]")}),it("With multiple values",function(){var[e,t]=c([`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID1"
       name="_value[0]"
       value="One">`,`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID2"
       name="_value[1]"
       value="Two">`,`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID3"
       name="_value[2]"
       value="Three">`]);expect(t.val()).toEqual("3"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(3),expect(e.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(3);let i=e.$(".djblets-c-list-edit-widget__input").eq(0),o=(expect(i.val()).toEqual("One"),expect(i.attr("id")).toEqual("_value_UUID1"),expect(i.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__input").eq(1));expect(o.val()).toEqual("Two"),expect(o.attr("id")).toEqual("_value_UUID2"),expect(o.attr("name")).toEqual("_value[1]");var n=e.$(".djblets-c-list-edit-widget__input").eq(2);expect(n.val()).toEqual("Three"),expect(n.attr("id")).toEqual("_value_UUID3"),expect(n.attr("name")).toEqual("_value[2]"),e.$(".djblets-c-list-edit-widget__remove-item").eq(1).click(),expect(t.val()).toEqual("2"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(2),expect(e.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(2),i=e.$(".djblets-c-list-edit-widget__input").eq(0),expect(i.val()).toEqual("One"),expect(i.attr("id")).toEqual("_value_UUID1"),expect(i.attr("name")).toEqual("_value[0]"),o=e.$(".djblets-c-list-edit-widget__input").eq(1),expect(o.val()).toEqual("Three"),expect(o.attr("id")).toEqual("_value_UUID3"),expect(o.attr("name")).toEqual("_value[1]"),e.$(".djblets-c-list-edit-widget__remove-item").eq(1).click(),expect(t.val()).toEqual("1"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(1),expect(e.$(".djblets-c-list-edit-widget__remove-item").length).toEqual(1),i=e.$(".djblets-c-list-edit-widget__input").eq(0),expect(i.val()).toEqual("One"),expect(i.attr("id")).toEqual("_value_UUID1"),expect(i.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__remove-item").click(),expect(t.val()).toEqual("1"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(1),i=e.$(".djblets-c-list-edit-widget__input").eq(0),expect(i.val()).toEqual(""),expect(i.attr("id")).toMatch(/^_value_djblets-list-edit-row\d+/),expect(i.attr("name")).toEqual("_value[0]")})}),describe("Addition",function(){it("With values",function(){var[e,t]=c([`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID1",
       name="_value[0]"
       value="One">`,`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID2",
       name="_value[1]"
       value="Two">`,`<input type="text"
       class="djblets-c-list-edit-widget__input"
       id="_value_UUID3",
       name="_value[2]"
       value="Three">`]),t=(e.$(".djblets-c-list-edit-widget__add-item").click(),expect(t.val()).toEqual("4"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(4),e.$(".djblets-c-list-edit-widget__input").eq(0)),t=(expect(t.val()).toEqual("One"),expect(t.attr("id")).toEqual("_value_UUID1"),expect(t.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__input").eq(1)),t=(expect(t.val()).toEqual("Two"),expect(t.attr("id")).toEqual("_value_UUID2"),expect(t.attr("name")).toEqual("_value[1]"),e.$(".djblets-c-list-edit-widget__input").eq(2)),t=(expect(t.val()).toEqual("Three"),expect(t.attr("id")).toEqual("_value_UUID3"),expect(t.attr("name")).toEqual("_value[2]"),e.$(".djblets-c-list-edit-widget__input").eq(3));expect(t.val()).toEqual(""),expect(t.attr("id")).toMatch(/^_value_djblets-list-edit-row\d+/),expect(t.attr("name")).toEqual("_value[3]")}),it("With no values",function(){var[e,t]=c([]),t=(e.$(".djblets-c-list-edit-widget__add-item").click(),expect(t.val()).toEqual("2"),expect(e.$(".djblets-c-list-edit-widget__entry").length).toEqual(2),e.$(".djblets-c-list-edit-widget__input").eq(0)),t=(expect(t.val()).toEqual(""),expect(t.attr("id")).toEqual("_value_0"),expect(t.attr("name")).toEqual("_value[0]"),e.$(".djblets-c-list-edit-widget__input").eq(1));expect(t.val()).toEqual(""),expect(t.attr("id")).toMatch(/^_value_djblets-list-edit-row\d+/),expect(t.attr("name")).toEqual("_value[1]")})})}),suite("djblets/integrations/views/AddIntegrationPopupView",function(){describe("Rendering",function(){it("With integrations",function(){var e=new Djblets.AddIntegrationPopupView({integrations:[{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"}]}),e=(e.render(),expect(e.$el.hasClass("-is-empty")).toBe(!1),e.$el.find(".djblets-c-integration"));expect(e.length).toBe(2);let t=e.eq(0),i=(expect(t.children("a").attr("href")).toBe("int1/add/"),expect(t.find(".djblets-c-integration__name").text()).toBe("Int1"),expect(t.find(".djblets-c-integration__description").text().trim()).toBe("Int1 Description"),t.find(".djblets-c-integration__icon"));expect(i.attr("src")).toBe("data:test,int1"),expect(i.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x"),t=e.eq(1),expect(t.children("a").attr("href")).toBe("int2/add/"),expect(t.find(".djblets-c-integration__name").text()).toBe("Int2"),expect(t.find(".djblets-c-integration__description").text().trim()).toBe("Int2 Description"),i=t.find(".djblets-c-integration__icon"),expect(i.attr("src")).toBe("data:test,int2"),expect(i.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x")}),it("Without integrations",function(){var e=new Djblets.AddIntegrationPopupView({integrations:[]}),e=(e.render(),expect(e.$el.hasClass("-is-empty")).toBe(!0),e.$(".djblets-c-integrations-popup__empty"));expect(e.length).toBe(1),expect(e.text().trim()).toBe("There are no integrations currently installed.")})})}),suite("djblets/integrations/views/IntegrationConfigListView",function(){const t=_.template(`<div class="djblets-c-integration-configs">
 <div class="djblets-l-config-forms-container">
  <table class="djblets-c-config-forms-list"></table>
 </div>
</div>`);let i,o;beforeEach(function(){var e=$(t()).appendTo($testsScratch);(o=new Djblets.IntegrationConfigListView({configs:[{editURL:"configs/1/",enabled:!0,id:1,integrationID:"int1",name:"Config 1"},{editURL:"configs/2/",enabled:!0,id:2,integrationID:"int2",name:"Config 2"},{editURL:"configs/3/",enabled:!1,id:3,integrationID:"int3",name:"Config 3"},{editURL:"configs/4/",enabled:!0,id:4,integrationID:"int1",name:"Config 4"}],el:e,integrationIDs:["int1","int2","int3"],integrationsMap:{int1:{addURL:"int1/add/",description:"Int1 Description",iconSrc:"data:test,int1",iconSrcSet:"data:test,int1 1x, data:test,int1@2x 2x",id:"int1",name:"Int1"},int2:{addURL:"int2/add/",description:"Int2 Description",iconSrc:"data:test,int2",iconSrcSet:"data:test,int2 1x, data:test,int2@2x 2x",id:"int2",name:"Int2"},int3:{addURL:"int3/add/",description:"Int3 Description",iconSrc:"data:test,int3",iconSrcSet:"data:test,int3 1x, data:test,int3@2x 2x",id:"int3",name:"Int3"}}})).render(),i=o.list.collection}),describe("Configurations",function(){let n,c,a,l;beforeEach(function(){var e=o.listView.$("tr");expect(e.length).toBe(4),n=e.eq(0),c=e.eq(1),a=e.eq(2),l=e.eq(3)}),describe("Rendering",function(){it("Icon",function(){var e=n.find(".djblets-c-integration-config__name img"),t=c.find(".djblets-c-integration-config__name img"),i=a.find(".djblets-c-integration-config__name img"),o=l.find(".djblets-c-integration-config__name img");expect(e.attr("src")).toBe("data:test,int1"),expect(t.attr("src")).toBe("data:test,int2"),expect(i.attr("src")).toBe("data:test,int3"),expect(o.attr("src")).toBe("data:test,int1"),expect(e.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x"),expect(t.attr("srcset")).toBe("data:test,int2 1x, data:test,int2@2x 2x"),expect(i.attr("srcset")).toBe("data:test,int3 1x, data:test,int3@2x 2x"),expect(o.attr("srcset")).toBe("data:test,int1 1x, data:test,int1@2x 2x")}),it("Name",function(){var e=n.find(".djblets-c-integration-config__name a"),t=c.find(".djblets-c-integration-config__name a"),i=a.find(".djblets-c-integration-config__name a"),o=l.find(".djblets-c-integration-config__name a");expect(e.text()).toBe("Config 1"),expect(t.text()).toBe("Config 2"),expect(i.text()).toBe("Config 3"),expect(o.text()).toBe("Config 4"),expect(e.attr("href")).toBe("configs/1/"),expect(t.attr("href")).toBe("configs/2/"),expect(i.attr("href")).toBe("configs/3/"),expect(o.attr("href")).toBe("configs/4/")}),it("Integration name",function(){var e=n.find(".djblets-c-integration-config__integration-name"),t=c.find(".djblets-c-integration-config__integration-name"),i=a.find(".djblets-c-integration-config__integration-name"),o=l.find(".djblets-c-integration-config__integration-name");expect(e.text().trim()).toBe("Int1"),expect(t.text().trim()).toBe("Int2"),expect(i.text().trim()).toBe("Int3"),expect(o.text().trim()).toBe("Int1")}),it("Status",function(){expect(n.hasClass("-is-enabled")).toBe(!0),expect(c.hasClass("-is-enabled")).toBe(!0),expect(a.hasClass("-is-enabled")).toBe(!1),expect(l.hasClass("-is-enabled")).toBe(!0),expect(n.hasClass("-is-disabled")).toBe(!1),expect(c.hasClass("-is-disabled")).toBe(!1),expect(a.hasClass("-is-disabled")).toBe(!0),expect(l.hasClass("-is-disabled")).toBe(!1),expect(n.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled"),expect(c.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled"),expect(a.find(".djblets-c-config-forms-list__item-state").text()).toBe("Disabled"),expect(l.find(".djblets-c-config-forms-list__item-state").text()).toBe("Enabled")})}),describe("Actions",function(){it("Delete",function(){var e=i.at(0);spyOn(e,"destroy").and.callThrough(),spyOn(e,"sync"),spyOn($.fn,"modalBox").and.callFake(e=>e.buttons[1].click()),n.find(".config-forms-list-action-delete").click(),expect($.fn.modalBox).toHaveBeenCalled(),expect(e.destroy).toHaveBeenCalled(),expect(i.length).toBe(3),expect(o.listView.$("tr").length).toBe(3)})})})}),suite("djblets/utils/urls",function(){describe("buildURL",function(){it("With just baseURL",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/"});expect(e).toBe("https://example.com/abc123/")}),describe("With anchor",function(){it('With leading "#"',function(){var e=Djblets.buildURL({anchor:"#my-anchor",baseURL:"https://example.com/abc123/"});expect(e).toBe("https://example.com/abc123/#my-anchor")}),it('Without leading "#"',function(){var e=Djblets.buildURL({anchor:"my-anchor",baseURL:"https://example.com/abc123/"});expect(e).toBe("https://example.com/abc123/#my-anchor")})}),describe("With queryData",function(){describe("As string",function(){it('With leading "?"',function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"?a=b&c=d"});expect(e).toBe("https://example.com/abc123/?a=b&c=d")}),it('Without leading "?"',function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:"a=b&c=d"});expect(e).toBe("https://example.com/abc123/?a=b&c=d")}),it("Empty",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:""});expect(e).toBe("https://example.com/abc123/")})}),describe("As object",function(){it("With value",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{a:"b"}});expect(e).toBe("https://example.com/abc123/?a=b")}),it("Empty",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:{}});expect(e).toBe("https://example.com/abc123/")})}),describe("As array",function(){it("With value",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[{name:"a",value:"b"},{name:"c",value:"d"}]});expect(e).toBe("https://example.com/abc123/?a=b&c=d")}),it("Empty",function(){var e=Djblets.buildURL({baseURL:"https://example.com/abc123/",queryData:[]});expect(e).toBe("https://example.com/abc123/")})})}),it("With all options",function(){var e=Djblets.buildURL({anchor:"my-anchor",baseURL:"https://example.com/abc123/",queryData:"a=b&c=d"});expect(e).toBe("https://example.com/abc123/?a=b&c=d#my-anchor")})}),describe("parseQueryString",function(){it("Empty query string",function(){expect(Djblets.parseQueryString("")).toEqual({})}),it("Basic query strings",function(){expect(Djblets.parseQueryString("?a=b&c=d&e=f")).toEqual({a:"b",c:"d",e:"f"})}),it("Keys without values",function(){expect(Djblets.parseQueryString("?abc=def&ghi")).toEqual({abc:"def",ghi:null})}),describe("Multiple values for keys",function(){it("With allowMultiValue=true",function(){var e=Djblets.parseQueryString("?a=1&a=2&a=3&b=4",{allowMultiValue:!0});expect(e).toEqual({a:["1","2","3"],b:"4"})}),it("Without allowMultiValue=true",function(){expect(Djblets.parseQueryString("?a=1&a=2&a=3&b=4")).toEqual({a:"3",b:"4"})})})})})}.call(this);
